##############################################################################
# File:    intram.cmd
# 
# Purpose: Linker command file template for MC56F8006 C environment.
# Author:  Quinten Brooks, Freescale Semiconductor MCD IC Design Phoenix
# Email:   quinten.brooks@freescale.com
# Date:    2007.03.08
#
##############################################################################
# Note: This file defines the memory map and determines where all compiled 
#       code will be placed.  There are no restrictions on where any 
#       initialization code, application code, and interrupt service routines
#       should reside in memory.  However, it is REQUIRED that code containing
#       the interrupt vector table be placed at the beginning of the memory
#       segment used during boot.
##############################################################################


##############################################################################
# Define the chip memory map for Anguilla White
##############################################################################
MEMORY {
   .pFlash  (RWX):  ORIGIN=0x0000,   LENGTH=0x1FF7
   .pConfig (RWX):  ORIGIN=0x1FF7,   LENGTH=0x9
   .pRAM    (RWX):  ORIGIN=0x8000,   LENGTH=0x3D6
   .xRAM    (RW):   ORIGIN=0x0000,   LENGTH=0x3D6  
   .xNoInit (RW):   ORIGIN=0x03D6,   LENGTH=0x2A
}   // End of "MEMORY" declaration


##############################################################################
# Prevent removal of unused code in certain files and functions.
##############################################################################
KEEP_SECTION { vectors_ram.text, .noinit, .flscfg }
FORCE_ACTIVE { Fvector_table, Fvector_table_ram }


##############################################################################
# Determine location of source code and data in chip memory.
##############################################################################
SECTIONS {

   ///////////////////////////////////////////////////////////////////////////
   // Section: Internal Flash
   ///////////////////////////////////////////////////////////////////////////
   //
   // Note: This section contains the vector table and application code by
   //       default.
   ///////////////////////////////////////////////////////////////////////////
   .SectionFlash: {
      Fflash_start = .;             # Save 1st Flash address
      * (vectors.text)              # Add interrupt vector table
      * (CODE_FLASH.text)           # Add "CODE_FLASH" section
      Fflash_end = .;               # Save last Flash address
      Fflash_size = Fflash_end - Fflash_start;
   } > .pFlash


   ///////////////////////////////////////////////////////////////////////////
   // Section: Flash Configuration Block
   ///////////////////////////////////////////////////////////////////////////
   //
   // Note: This section contains the flash configuration block used to 
   //       control security features.
   ///////////////////////////////////////////////////////////////////////////
   .SectionFlashConfig: {
      * (.flscfg)                   # Add Flash Configuration Block
   } > .pConfig


   ///////////////////////////////////////////////////////////////////////////
   // Section: Program RAM
   ///////////////////////////////////////////////////////////////////////////
   //
   // Note: This section contains all program code intended for RAM.  A 
   //       duplicate copy of the interrupt vector table can be included in
   //       this section to allow interrupt functionality.
   ///////////////////////////////////////////////////////////////////////////   
   .SectionPRAM: {
      Fpram_start = .;              # Save 1st PRAM address
      Fvba = . / 128;               # Export Vector Base Address
      * (vectors_ram.text)          # Add RAM interrupt vector table
      cpu.c (.text)                 # Add runtime init code
      * (isr.text)                  # Add interrupt service routines
      * (rtlib.text)                # Add runtime libraries
      * (fp_engine.text)            # Add floating-point engine
      * (CODE_RAM.text)             # Section used from the source code
      * (.text)                     # Add remaining source code
      Fpram_end = .;                # Save last PRAM address
      Fpram_size = Fpram_end - Fpram_start;
   } > .pRAM


   ///////////////////////////////////////////////////////////////////////////
   // Section: Data RAM
   ///////////////////////////////////////////////////////////////////////////   
   //
   // Note: This section comprises the CONST, DATA, BSS and STACK segments.
   //       The "heap" will NOT be used in our software.
   ///////////////////////////////////////////////////////////////////////////
   .SectionXRAM: {
      . = . + Fpram_size;               # Skip memory used by PRAM
      Fxram_start = .;                  # Save 1st XRAM address
      * (.const.data)                   # Add data constants
      * (fp_state.data)                 # Add globals from "fp_state" section
      * (rtlib.data)                    # Add runtime library variables
      * (.data)                         # Add remaining globals
      . = ALIGN(1);                     # Pad location counter if needed (byte)
      Fbss_start = .;                   # Save 1st BSS address
      * (rtlib.bss.lo)                  # Add runtime library BSS
      * (rtlib.bss)                     # Add runtime library BSS
      * (.bss)                          # Add remaining BSS variables
      Fbss_end = .;                     # Save last BSS address
      . = ALIGN(4) + 1;                 # Long-align SP (ODD)
      Fsp_start = .;                    # Mark beginning of stack section
      Fsp_size = 0x40;                  # SP size (in words)
      Fsp_end = . + Fsp_size;           # Stack size
      . = Fsp_end;                      # Update location counter
      Fxram_end = .;                    # Save last XRAM address
      Fxram_size = Fxram_end - Fxram_start;
      Fbss_size = Fbss_end - Fbss_start;
   } > .xRAM


   ///////////////////////////////////////////////////////////////////////////
   // Section: Non-Initialized Data RAM
   ///////////////////////////////////////////////////////////////////////////
   //
   // Note: This section is left unmodified by the runtime initialization 
   //       code.  Data from this section should not appear in any S-records
   //       or Verilog memory image files.
   ///////////////////////////////////////////////////////////////////////////
   .SectionNoInit: {
      Fnoinit_start = .;            # Save 1st NOINIT address
      * (.noinit)                   # Add non-initialized globals
      Fnoinit_end = .;              # Save last NOINIT address
      Fnoinit_size = Fnoinit_end - Fnoinit_start;
   } > .xNoInit

}  // End of "SECTIONS" declaration
